/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package chapter6;

import java.time.*;
import static java.time.Month.*;
import static java.time.temporal.ChronoUnit.HOURS;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class DataSource {
    public Person[] people=new Person[3];
    public Meeting[] meetings=new Meeting[4];
    
    public DataSource(){

        //Populate the data source.  We will do this explicity
        //but we could equally create the instances from a database or file.
        
        //Create people.
        Person me = new Person("Employee", "matthew", "gregory",46);
        Person myCustomer = new Person("Customer", "John", "Smith",20);
        Person myColleague = new Person("Employee", "Penny", "Chan",41);
        
        //Add them to our array
        people[0]=me;
        people[1]=myCustomer;
        people[2]=myColleague;

        //Create meetings
        Meeting myMeeting = new Meeting(me);
        Meeting initialMeeting = new Meeting(me,myCustomer);
        Meeting internalMeeting = new Meeting(me,myColleague);
        Meeting followupMeeting = new Meeting(me,myColleague,myCustomer);
        
        //Add agenda items to followupMeeting
        followupMeeting.agendaItems[0] = "Discuss Design";
        followupMeeting.agendaItems[1] = "Agree on Design";
        followupMeeting.agendaItems[2] = "Document the agreement and prepare design for publishing.";
        
        //Add them to our array
        meetings[0]=myMeeting;
        meetings[1]=initialMeeting;
        meetings[2]=internalMeeting;
        meetings[3]=followupMeeting;
    }    

}
